<?php
// Dil seçimi için basit bir kontrol
$lang = isset($_GET['lang']) ? $_GET['lang'] : 'tr';
$available_langs = ['tr', 'en', 'de'];
if (!in_array($lang, $available_langs)) {
    $lang = 'tr';
}

$translations = [
    'tr' => [
        'title' => 'Altek Kağıt',
        'menu_home' => 'Anasayfa',
        'menu_about' => 'Biz Kimiz?',
        'menu_what' => 'Ne Yapıyoruz?',
        'menu_how' => 'Nasıl Yapıyoruz?',
        'menu_who' => 'Kime Hizmet Veriyoruz?',
        'menu_contact' => 'Bize Ulaşın',
        'years_exp' => '35 YILLIK',
        'experience' => 'TECRÜBE',
        'about_title' => 'Biz Kimiz?',
        'about_text' => 'Altek Kağıt olarak; esnek ambalaja yönelik grafik tasarım, renk ayrımı ve klişe üretim hizmetlerini entegre bir şekilde sunma hedefiyle, 1986 yılında İzmir\'de yolculuğumuza başladık.',
        'mission_text' => '35 yıldır; "son teknoloji", "en kaliteli ürün" ve "sürdürülebilir doğru hizmet" misyonuyla yolculuğumuza ilk günkü heyecanımızla devam ediyoruz.',
        'service_title' => 'Tüm dünyada; flekso baskı makinesi kullanan tüm esnek ambalaj firmalarına hizmet veriyoruz.',
        'quick_menu' => 'Hızlı Menü',
        'izmir_office' => 'İzmir Ofis',
        'read_more' => 'Devamını Oku',
        'contact_us' => 'Bize Ulaşın',
        'copyright' => '© 2025 Altek Kağıt. Tüm Hakları Saklıdır.',
        'how_title' => 'Nasıl Yapıyoruz?',
        'how_text' => 'En son teknolojik ekipmanlar ve uzman kadromuzla, tasarımdan üretime kadar tüm süreçlerde kaliteden ödün vermeden çalışıyoruz.',
        'more_info' => 'Daha Fazla Bilgi',
        'who_title' => 'Kime Hizmet Veriyoruz?',
        'what_title' => 'Ne Yapıyoruz?',
        'design_title' => 'Grafik Tasarım',
        'design_desc' => 'Markanıza özel, etkileyici ve özgün grafik tasarım çözümleri sunuyoruz.',
        'color_title' => 'Renk Ayrımı',
        'color_desc' => 'Profesyonel renk ayrımı hizmetimizle baskılarınızda mükemmel sonuçlar elde edin.',
        'production_title' => 'Klişe Üretimi',
        'production_desc' => 'Son teknoloji ekipmanlarla yüksek kaliteli klişe üretimi gerçekleştiriyoruz.'
    ],
    'en' => [
        'title' => 'Altek Paper',
        'menu_home' => 'Home',
        'menu_about' => 'About Us',
        'menu_what' => 'What We Do',
        'menu_how' => 'How We Do It',
        'menu_who' => 'Who We Serve',
        'menu_contact' => 'Contact Us',
        'years_exp' => '35 YEARS OF',
        'experience' => 'EXPERIENCE',
        'about_title' => 'About Us',
        'about_text' => 'As Altek Paper; we started our journey in Izmir in 1986 with the goal of providing integrated graphic design, color separation and cliché production services for flexible packaging.',
        'mission_text' => 'For 35 years; we continue our journey with the same excitement as the first day with the mission of "latest technology", "highest quality product" and "sustainable right service".',
        'service_title' => 'We serve all flexible packaging companies using flexo printing machines worldwide.',
        'quick_menu' => 'Quick Menu',
        'izmir_office' => 'Izmir Office',
        'read_more' => 'Read More',
        'contact_us' => 'Contact Us',
        'copyright' => '© 2025 Altek Paper. All Rights Reserved.',
        'how_title' => 'How We Do It',
        'how_text' => 'We work without compromising on quality in all processes from design to production with the latest technological equipment and our expert staff.',
        'more_info' => 'More Information',
        'who_title' => 'Who We Serve',
        'what_title' => 'What We Do',
        'design_title' => 'Graphic Design',
        'design_desc' => 'We offer impressive and original graphic design solutions specific to your brand.',
        'color_title' => 'Color Separation',
        'color_desc' => 'Get perfect results in your prints with our professional color separation service.',
        'production_title' => 'Cliché Production',
        'production_desc' => 'We produce high quality clichés with state-of-the-art equipment.'
    ],
    'de' => [
        'title' => 'Altek Papier',
        'menu_home' => 'Startseite',
        'menu_about' => 'Über Uns',
        'menu_what' => 'Was Wir Machen',
        'menu_how' => 'Wie Wir Es Machen',
        'menu_who' => 'Wem Wir Dienen',
        'menu_contact' => 'Kontakt',
        'years_exp' => '35 JAHRE',
        'experience' => 'ERFAHRUNG',
        'about_title' => 'Über Uns',
        'about_text' => 'Als Altek Papier; wir begannen unsere Reise 1986 in Izmir mit dem Ziel, integrierte Grafikdesign-, Farbtrennung- und Klischeeproduktionsdienste für flexible Verpackungen anzubieten.',
        'mission_text' => 'Seit 35 Jahren; wir setzen unsere Reise mit der gleichen Begeisterung wie am ersten Tag fort, mit der Mission "neueste Technologie", "höchste Produktqualität" und "nachhaltiger richtiger Service".',
        'service_title' => 'Wir bedienen weltweit alle Unternehmen für flexible Verpackungen, die Flexodruckmaschinen verwenden.',
        'quick_menu' => 'Schnellmenü',
        'izmir_office' => 'Izmir Büro',
        'read_more' => 'Weiterlesen',
        'contact_us' => 'Kontaktieren Sie Uns',
        'copyright' => '© 2025 Altek Papier. Alle Rechte vorbehalten.',
        'how_title' => 'Wie Wir Es Machen',
        'how_text' => 'Wir arbeiten ohne Kompromisse bei der Qualität in allen Prozessen vom Design bis zur Produktion mit den neuesten technologischen Geräten und unserem Fachpersonal.',
        'more_info' => 'Mehr Informationen',
        'who_title' => 'Wem Wir Dienen',
        'what_title' => 'Was Wir Machen',
        'design_title' => 'Grafikdesign',
        'design_desc' => 'Wir bieten beeindruckende und originelle Grafikdesignlösungen speziell für Ihre Marke.',
        'color_title' => 'Farbtrennung',
        'color_desc' => 'Erzielen Sie perfekte Ergebnisse in Ihren Drucken mit unserem professionellen Farbtrennungsservice.',
        'production_title' => 'Klischeeproduktion',
        'production_desc' => 'Wir produzieren hochwertige Klischees mit modernster Ausrüstung.'
    ]
];

// Aktif dil için çevirileri al
$t = $translations[$lang];
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $t['title']; ?></title>
    <meta name="description" content="Altek Kağıt - Esnek ambalaja yönelik grafik tasarım, renk ayrımı ve klişe üretim hizmetleri">
    
    <!-- Favicon -->
    <link rel="icon" href="assets/images/favicon.ico" type="image/x-icon">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- AOS Animation Library -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css">
    
    <!-- Swiper Slider -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css">
    

   
    <style>
        :root {
            --primary: #e60023;
            --secondary: #333;
            --dark: #212529;
            --light: #f8f9fa;
            --light-gray: #f2f2f2;
            --gray: #6c757d;
            --success: #28a745;
            --info: #17a2b8;
            --warning: #ffc107;
            --danger: #dc3545;
            --transition: all 0.3s ease;
            --border-radius: 4px;
            --box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Montserrat', sans-serif;
            color: var(--dark);
            line-height: 1.6;
            overflow-x: hidden;
            position: relative;
        }
        
        a {
            text-decoration: none;
            color: inherit;
            transition: var(--transition);
        }
        
        ul {
            list-style: none;
        }
        
        img {
            max-width: 70%;
            height: auto;
        }
        
        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 15px;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 28px;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: var(--border-radius);
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            text-align: center;
        }
        
        .btn:hover {
            background: #d40020;
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(230, 0, 35, 0.2);
        }
        
        .btn-outline {
            background: transparent;
            border: 2px solid var(--primary);
            color: var(--primary);
        }
        
        .btn-outline:hover {
            background: var(--primary);
            color: white;
        }
        
        .btn-gray {
            background: #666;
            color: white;
        }
        
        .btn-gray:hover {
            background: #555;
        }
        
        .section {
            padding: 80px 0;
        }
        
        .section-title {
            font-size: 36px;
            font-weight: 700;
            text-align: center;
            margin-bottom: 50px;
            position: relative;
        }
        
        .section-title:after {
            content: '';
            position: absolute;
            width: 80px;
            height: 4px;
            background: var(--primary);
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
        }
        /* Header Styles */
        .header {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background: white;
            z-index: 1000;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            transition: var(--transition);
        }
        
        .header.scrolled {
            padding: 10px 0;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .header-inner {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px 0;
        }
        
        .logo {
            width: 180px;
        }
        
        .nav-menu {
            display: flex;
            align-items: center;
        }
        
        .nav-item {
            margin: 0 15px;
        }
        
        .nav-link {
            color: var(--dark);
            font-weight: 500;
            font-size: 15px;
            position: relative;
        }
        
        .nav-link:hover {
            color: var(--primary);
        }
        
        .nav-link:after {
            content: '';
            position: absolute;
            width: 0;
            height: 2px;
            background: var(--primary);
            left: 0;
            bottom: -5px;
            transition: var(--transition);
        }
        
        .nav-link:hover:after {
            width: 100%;
        }
        
        .lang-switcher {
            display: flex;
            align-items: center;
            margin-left: 20px;
        }
        
        .lang-btn {
            margin: 0 5px;
            font-weight: 600;
            font-size: 14px;
        }
        
        .lang-btn.active {
            color: var(--primary);
        }
        
        .mobile-toggle {
            display: none;
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: var(--dark);
        }
        
        /* Hero Section */
        .hero {
            height: 100vh;
            background-image: linear-gradient(rgba(0,0,0,0.6), rgba(0,0,0,0.6)), url('assets/images/hero-bg.jpg');
            background-size: cover;
            background-position: center;
            display: flex;
            align-items: center;
            margin-top: 90px;
            position: relative;
        }
        
        .hero-content {
            color: white;
            text-align: right;
            max-width: 800px;
            margin-left: auto;
            padding-right: 50px;
        }
        
        .hero-title {
            font-size: 72px;
            font-weight: 800;
            margin-bottom: 10px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
            line-height: 1.2;
        }
        
        .hero-subtitle {
            font-size: 48px;
            font-weight: 600;
            margin-bottom: 30px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
        }
        
        .hero-accent {
            display: inline-block;
            width: 60px;
            height: 60px;
            background-color: var(--primary);
            margin-left: 15px;
            vertical-align: middle;
        }
        
        /* About Section */
        .about {
            background-color: white;
            position: relative;
        }
        
        /* Client Logos Styling */
.clients-logo {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    align-items: center;
    gap: 50px;
}

.clients-logo img {
    max-width: 230px;
    max-height: 230px;
    object-fit: contain;
    filter: grayscale(100%);
    transition: var(--transition);
    padding: 15px;
    background-color: white;
    border-radius: 8px;
    box-shadow: var(--box-shadow);
}

.clients-logo img:hover {
    filter: grayscale(0);
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0,0,0,0.15);
}

/* Responsive adjustments for client logos */
@media (max-width: 992px) {
    .clients-logo img {
        max-width: 150px;
        max-height: 150px;
    }
}

@media (max-width: 768px) {
    .clients-logo img {
        max-width: 130px;
        max-height: 130px;
        padding: 10px;
    }
}

@media (max-width: 576px) {
    .clients-logo {
        gap: 15px;
    }
    
    .clients-logo img {
        max-width: 110px;
        max-height: 110px;
    }
}

        
        .about-container {
            display: flex;
            flex-wrap: wrap;
        }
        
        .about-text {
            flex: 1;
            padding: 30px;
            background-color: var(--light-gray);
        }
        
        .about-text h3 {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
        
        .about-text p {
            font-size: 16px;
            line-height: 1.8;
            margin-bottom: 20px;
        }
        
        .mission-text {
            flex: 1;
            padding: 30px;
            background-color: white;
        }
        
        .mission-text p {
            font-size: 16px;
            line-height: 1.8;
            margin-bottom: 20px;
        }
        
        /* Services Section */
        .services {
            background-color: var(--light);
        }
        
        .service-item {
            text-align: center;
            margin-bottom: 40px;
        }
        
        .service-icon {
            font-size: 48px;
            color: var(--primary);
            margin-bottom: 20px;
        }
        
        .service-title {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .service-desc {
            font-size: 15px;
            color: var(--gray);
        }
        
        /* Gallery Section */
        .gallery {
            background-color: white;
        }
        
        .gallery-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            grid-gap: 20px;
        }
        
        .gallery-item {
            position: relative;
            overflow: hidden;
            border-radius: var(--border-radius);
            height: 250px;
        }
        
        .gallery-item img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: var(--transition);
        }
        
        .gallery-item:hover img {
            transform: scale(1.1);
        }
        
        .gallery-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: var(--transition);
        }
        
        .gallery-item:hover .gallery-overlay {
            opacity: 1;
        }
        
        .gallery-overlay i {
            color: white;
            font-size: 40px;
        }
        /* Testimonials Section */
        .testimonials {
            background-color: var(--light-gray);
        }
        
        .testimonial-slider {
            width: 100%;
            padding-bottom: 50px;
        }
        
        .testimonial-item {
            background: white;
            padding: 30px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            text-align: center;
        }
        
        .testimonial-text {
            font-style: italic;
            margin-bottom: 20px;
        }
        
        .testimonial-author {
            font-weight: 600;
            color: var(--primary);
        }
        
        .testimonial-company {
            font-size: 14px;
            color: var(--gray);
        }
        
        /* Contact Section */
        .contact {
            background-color: white;
        }
        
        .contact-container {
            display: flex;
            flex-wrap: wrap;
        }
        
        .contact-info {
            flex: 1;
            padding: 30px;
            background-color: var(--light-gray);
        }
        
        .contact-form {
            flex: 2;
            padding: 30px;
        }
        
        .contact-item {
            margin-bottom: 20px;
            display: flex;
            align-items: flex-start;
        }
        
        .contact-icon {
            color: var(--primary);
            font-size: 20px;
            margin-right: 15px;
            margin-top: 5px;
        }
        
        .contact-text h4 {
            font-size: 18px;
            margin-bottom: 5px;
        }
        
        .contact-text p {
            font-size: 15px;
            color: var(--gray);
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-family: inherit;
            font-size: 15px;
            transition: var(--transition);
        }
        
        .form-control:focus {
            border-color: var(--primary);
            outline: none;
        }
        
        textarea.form-control {
            height: 150px;
            resize: vertical;
        }
        
        /* Footer */
        .footer {
            background-color: var(--secondary);
            color: white;
            padding: 60px 0 0;
        }
        
        .footer-container {
            display: flex;
            flex-wrap: wrap;
        }
        
        .footer-column {
            flex: 1;
            min-width: 250px;
            margin-bottom: 30px;
        }
        
        .footer-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 20px;
            position: relative;
        }
        
        .footer-title:after {
            content: '';
            position: absolute;
            width: 40px;
            height: 3px;
            background: var(--primary);
            bottom: -10px;
            left: 0;
        }
        
        .footer-links li {
            margin-bottom: 10px;
        }
        
        .footer-links a {
            color: #ddd;
        }
        
        .footer-links a:hover {
            color: var(--primary);
            padding-left: 5px;
        }
        
        .footer-social {
            display: flex;
            margin-top: 20px;
        }
        
        .social-link {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255,255,255,0.1);
            color: white;
            margin-right: 10px;
        }
        
        .social-link:hover {
            background: var(--primary);
            transform: translateY(-5px);
        }
        
        .copyright {
            text-align: center;
            padding: 20px 0;
            border-top: 1px solid rgba(255,255,255,0.1);
            margin-top: 30px;
            font-size: 14px;
        }
        
        /* Responsive Styles */
        @media (max-width: 992px) {
            .hero-title {
                font-size: 56px;
            }
            
            .hero-subtitle {
                font-size: 36px;
            }
            
            .about-container {
                flex-direction: column;
            }
            
            .gallery-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .contact-container {
                flex-direction: column;
            }
        }
        
        @media (max-width: 768px) {
            .mobile-toggle {
                display: block;
            }
            
            .nav-menu {
                position: fixed;
                top: 90px;
                left: -100%;
                width: 100%;
                height: calc(100vh - 90px);
                background: white;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                transition: var(--transition);
                box-shadow: 0 5px 10px rgba(0,0,0,0.1);
            }
            
            .nav-menu.active {
                left: 0;
            }
            
            .nav-item {
                margin: 15px 0;
            }
            
            .hero-content {
                text-align: center;
                padding: 0 20px;
                margin: 0 auto;
            }
            
            .hero-title {
                font-size: 42px;
            }
            
            .hero-subtitle {
                font-size: 28px;
            }
            
            .section-title {
                font-size: 28px;
            }
            
            .gallery-grid {
                grid-template-columns: 1fr;
            }
            
            .footer-column {
                flex: 100%;
            }
        }
        
        /* Back to Top Button */
        .back-to-top {
            position: fixed;
            bottom: 30px;
            right: 30px;
            width: 50px;
            height: 50px;
            background: var(--primary);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            opacity: 0;
            visibility: hidden;
            transition: var(--transition);
            z-index: 999;
        }
        
        .back-to-top.active {
            opacity: 1;
            visibility: visible;
        }
        
        .back-to-top:hover {
            background: #d40020;
            transform: translateY(-5px);
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="container">
            <div class="header-inner">
                <a href="index.php" class="logo">
                    <img src="assets/images/logo.png" alt="Altek Kağıt ">
                </a>
                
                <button class="mobile-toggle">
                    <i class="fas fa-bars"></i>
                </button>
                
                <ul class="nav-menu">
                    <li class="nav-item">
                        <a href="#home" class="nav-link"><?php echo $t['menu_home']; ?></a>
                    </li>
                    <li class="nav-item">
                        <a href="#about" class="nav-link"><?php echo $t['menu_about']; ?></a>
                    </li>
                    <li class="nav-item">
                        <a href="#what" class="nav-link"><?php echo $t['menu_what']; ?></a>
                    </li>
                    <li class="nav-item">
                        <a href="#how" class="nav-link"><?php echo $t['menu_how']; ?></a>
                    </li>
                    <li class="nav-item">
                        <a href="#who" class="nav-link"><?php echo $t['menu_who']; ?></a>
                    </li>
                    <li class="nav-item">
                        <a href="#contact" class="nav-link"><?php echo $t['menu_contact']; ?></a>
                    </li>
                    
                    <div class="lang-switcher">
                        <a href="?lang=tr" class="lang-btn <?php echo $lang == 'tr' ? 'active' : ''; ?>">TR</a>
                        <a href="?lang=en" class="lang-btn <?php echo $lang == 'en' ? 'active' : ''; ?>">EN</a>
                        <a href="?lang=de" class="lang-btn <?php echo $lang == 'de' ? 'active' : ''; ?>">DE</a>
                    </div>
                </ul>
            </div>
        </div>
    </header>
    <!-- Hero Section -->
    <section class="hero" id="home">
        <div class="container">
            <div class="hero-content" data-aos="fade-left" data-aos-delay="200">
                <h1 class="hero-title"><?php echo $t['years_exp']; ?> <span class="hero-accent"></span></h1>
                <h2 class="hero-subtitle"><?php echo $t['experience']; ?></h2>
                <a href="#contact" class="btn"><?php echo $t['contact_us']; ?></a>
            </div>
        </div>
    </section>
    
    <!-- About Section -->
    <section class="about section" id="about">
        <div class="container">
            <h2 class="section-title"><?php echo $t['about_title']; ?></h2>
            
            <div class="about-container">
                <div class="about-text" data-aos="fade-right">
                    <p><?php echo $t['about_text']; ?></p>
                    <a href="#" class="btn btn-outline"><?php echo $t['read_more']; ?></a>
                </div>
                
                <div class="mission-text" data-aos="fade-left">
                    <p><?php echo $t['mission_text']; ?></p>
                    <img src="assets/images/about-img.jpeg" alt="Altek Kağıt">
                </div>
            </div>
        </div>
    </section>
    
<!-- Services Section -->
<section class="services section" id="what">
    <div class="container">
        <h2 class="section-title"><?php echo $t['what_title']; ?></h2>
        
        <div class="row">
            <div class="service-item" data-aos="fade-up">
                <div class="service-icon">
                    <i class="fas fa-paint-brush"></i>
                </div>
                <h3 class="service-title"><?php echo $t['design_title']; ?></h3>
                <p class="service-desc"><?php echo $t['design_desc']; ?></p>
            </div>
            
            <div class="service-item" data-aos="fade-up" data-aos-delay="100">
                <div class="service-icon">
                    <i class="fas fa-layer-group"></i>
                </div>
                <h3 class="service-title"><?php echo $t['color_title']; ?></h3>
                <p class="service-desc"><?php echo $t['color_desc']; ?></p>
            </div>
            
            <div class="service-item" data-aos="fade-up" data-aos-delay="200">
                <div class="service-icon">
                    <i class="fas fa-print"></i>
                </div>
                <h3 class="service-title"><?php echo $t['production_title']; ?></h3>
                <p class="service-desc"><?php echo $t['production_desc']; ?></p>
            </div>
        </div>
    </div>
</section>


<!-- How We Work Section -->
<section class="section" id="how">
    <div class="container">
        <h2 class="section-title"><?php echo $t['how_title']; ?></h2>
        
        <div class="row" style="display: flex; align-items: center; flex-wrap: wrap; margin-top: 40px;">
            <div class="col-image" data-aos="fade-right" style="flex: 1; min-width: 250px; max-width: 350px; padding: 15px;">
                <img src="assets/images/client5.jpeg" alt="<?php echo $t['how_title']; ?>" style="width: 100%; max-width: 300px; height: auto; border-radius: 8px; box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
            </div>
            
            <div class="col-text" data-aos="fade-left" style="flex: 2; min-width: 300px; padding: 25px;">
                <p style="font-size: 16px; line-height: 1.8;"><?php echo $t['how_text']; ?></p>
                <a href="#contact" class="btn btn-outline" style="margin-top: 20px;"><?php echo $t['more_info']; ?></a>
            </div>
        </div>
    </div>
</section>


<!-- Who We Serve Section -->
<section class="section" id="who" style="background-color: var(--light-gray);">
    <div class="container">
        <h2 class="section-title"><?php echo $t['who_title']; ?></h2>
        
        <div class="row" data-aos="fade-up">
            <p class="text-center" style="max-width: 800px; margin: 0 auto 40px;"><?php echo $t['service_title']; ?></p>
            
            <div class="clients-logo">
                <!-- Client logos would go here -->
                <img src="assets/images/client1.jpeg" alt="<?php echo $t['title']; ?>">
                <img src="assets/images/client2.jpeg" alt="<?php echo $t['title']; ?>">
                <img src="assets/images/client3.jpeg" alt="<?php echo $t['title']; ?>">
                <img src="assets/images/client4.jpeg" alt="<?php echo $t['title']; ?>">
                <img src="assets/images/client5.jpeg" alt="<?php echo $t['title']; ?>">
            </div>
        </div>
    </div>
</section>


    
    <!-- Contact Section -->
    <section class="contact section" id="contact">
        <div class="container">
            <h2 class="section-title"><?php echo $t['contact_us']; ?></h2>
            
            <div class="contact-container">
                <div class="contact-info" data-aos="fade-right">
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="contact-text">
                            <h4><?php echo $t['izmir_office']; ?></h4>
                            <p>Kazım Dirik Mah. 367/1 Sok. No:10/A Bornova, İzmir</p>
                        </div>
                    </div>
                    
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-phone-alt"></i>
                        </div>
                        <div class="contact-text">
                            <h4>Telefon</h4>
                            <p>+90 (232) 123 45 67</p>
                        </div>
                    </div>
                    
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="contact-text">
                            <h4>E-posta</h4>
                            <p>info@altekkagit.com</p>
                        </div>
                    </div>
                </div>
                
                <div class="contact-form" data-aos="fade-left">
                    <form action="process.php" method="POST">
                        <div class="form-group">
                            <input type="text" class="form-control" placeholder="Adınız Soyadınız" required>
                        </div>
                        
                        <div class="form-group">
                            <input type="email" class="form-control" placeholder="E-posta Adresiniz" required>
                        </div>
                        
                        <div class="form-group">
                            <input type="tel" class="form-control" placeholder="Telefon Numaranız">
                        </div>
                        
                        <div class="form-group">
                            <textarea class="form-control" placeholder="Mesajınız" required></textarea>
                        </div>
                        
                        <button type="submit" class="btn">Gönder</button>
                    </form>
                </div>
            </div>
        </div>
    </section>
    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-container">
                <div class="footer-column">
                    <img src="assets/images/logo-removebg-preview.png" alt="Altek Kağıt" class="footer-logo">
                    <p style="margin-top: 20px; color: #ddd;">35 yıldır esnek ambalaja yönelik grafik tasarım, renk ayrımı ve klişe üretim hizmetleri veriyoruz.</p>
                    <div class="footer-social">
                        <a href="#" class="social-link"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
                
                <div class="footer-column">
                    <h3 class="footer-title"><?php echo $t['quick_menu']; ?></h3>
                    <ul class="footer-links">
                        <li><a href="#home"><?php echo $t['menu_home']; ?></a></li>
                        <li><a href="#about"><?php echo $t['menu_about']; ?></a></li>
                        <li><a href="#what"><?php echo $t['menu_what']; ?></a></li>
                        <li><a href="#how"><?php echo $t['menu_how']; ?></a></li>
                        <li><a href="#who"><?php echo $t['menu_who']; ?></a></li>
                        <li><a href="#contact"><?php echo $t['menu_contact']; ?></a></li>
                    </ul>
                </div>
                
                <div class="footer-column">
                    <h3 class="footer-title"><?php echo $t['izmir_office']; ?></h3>
                    <p style="color: #ddd;">Kazım Dirik Mah. 367/1 Sok. No:10/A Bornova, İzmir</p>
                    <p style="color: #ddd;">Tel: +90 (232) 123 45 67</p>
                    <p style="color: #ddd;">Fax: +90 (232) 123 45 68</p>
                </div>
                
                <div class="footer-column">
                    <h3 class="footer-title">Sosyal Medya</h3>
                    <p style="color: #ddd;">Bizi sosyal medyada takip edin ve güncel haberlerden haberdar olun.</p>
                    <div class="footer-social" style="margin-top: 15px;">
                        <a href="#" class="social-link"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
            </div>
            
            <div class="copyright">
                <?php echo $t['copyright']; ?>
            </div>
        </div>
    </footer>
    
    <!-- Back to Top Button -->
    <a href="#" class="back-to-top" id="backToTop">
        <i class="fas fa-arrow-up"></i>
    </a>
    
    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Initialize AOS
            AOS.init({
                duration: 800,
                easing: 'ease-in-out',
                once: true
            });
            
            // Header scroll class
            $(window).scroll(function() {
                if ($(this).scrollTop() > 100) {
                    $('.header').addClass('scrolled');
                    $('#backToTop').addClass('active');
                } else {
                    $('.header').removeClass('scrolled');
                    $('#backToTop').removeClass('active');
                }
            });
            
            // Mobile menu toggle
            $('.mobile-toggle').click(function() {
                $('.nav-menu').toggleClass('active');
                $(this).find('i').toggleClass('fa-bars fa-times');
            });
            
            // Smooth scrolling for anchor links
            $('a[href*="#"]').not('[href="#"]').not('[href="#0"]').click(function(event) {
                if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
                    var target = $(this.hash);
                    target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
                    if (target.length) {
                        event.preventDefault();
                        $('html, body').animate({
                            scrollTop: target.offset().top - 90
                        }, 1000);
                        
                        if ($('.nav-menu').hasClass('active')) {
                            $('.nav-menu').removeClass('active');
                            $('.mobile-toggle').find('i').removeClass('fa-times').addClass('fa-bars');
                        }
                    }
                }
            });
            
            $('#backToTop').click(function(e) {
                e.preventDefault();
                $('html, body').animate({scrollTop: 0}, 800);
            });
            
            var testimonialSlider = new Swiper('.testimonial-slider', {
                slidesPerView: 1,
                spaceBetween: 30,
                loop: true,
                autoplay: {
                    delay: 5000,
                },
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },
                breakpoints: {
                    768: {
                        slidesPerView: 2,
                    },
                    992: {
                        slidesPerView: 3,
                    }
                }
            });
        });
    </script>
</body>
</html>
